/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import io.github.fabricators_of_create.porting_lib.event.client.FieldOfViewEvents;
import io.github.fabricators_of_create.porting_lib.event.client.RenderHandCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7417;
import net.minecraft.class_742;
import net.minecraft.class_746;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.events.ToolEquipmentChangeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.impl.InventoryModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ability.armor.ShieldStrapModifier;
import slimeknights.tconstruct.tools.modifiers.upgrades.armor.ItemFrameModifier;

public class ModifierClientEvents {
    private static final int SLOT_BACKGROUND_SIZE = 22;
    @Nonnull
    private static class_1799 nextOffhand = class_1799.field_8037;
    private static final List<class_1799> itemFrames = new ArrayList<class_1799>();

    public static void init() {
        ItemTooltipCallback.EVENT.register(ModifierClientEvents::onTooltipEvent);
        RenderHandCallback.EVENT.register(ModifierClientEvents::renderHand);
        ToolEquipmentChangeEvent.EVENT.register(ModifierClientEvents::equipmentChange);
        FieldOfViewEvents.MODIFY.register(ModifierClientEvents::handleZoom);
    }

    static void onTooltipEvent(class_1799 stack, class_1836 context, List<class_2561> lines) {
        if (stack.method_7909() instanceof IModifiableDisplay) {
            lines.removeIf(text -> {
                class_7417 patt2917$temp = text.method_10851();
                if (patt2917$temp instanceof class_2588) {
                    class_2588 translatableContents = (class_2588)patt2917$temp;
                    return translatableContents.method_11022().equals("item.durability");
                }
                return false;
            });
        }
    }

    static void renderHand(RenderHandCallback.RenderHandEvent event) {
        class_1268 hand = event.getHand();
        class_746 player = class_310.method_1551().field_1724;
        if (hand != class_1268.field_5810 || player == null) {
            return;
        }
        class_1799 mainhand = player.method_6047();
        class_1799 offhand = event.getItemStack();
        if (mainhand.method_31573(TinkerTags.Items.TWO_HANDED)) {
            ToolStack tool = ToolStack.from(mainhand);
            IModDataView volatileData = tool.getVolatileData();
            boolean noInteraction = volatileData.getBoolean(IModifiable.NO_INTERACTION);
            if (!(noInteraction || volatileData.getBoolean(IModifiable.DEFER_OFFHAND) || offhand.method_7909() instanceof class_1747 && tool.getModifierLevel(TinkerModifiers.exchanging.getId()) != 0)) {
                event.setCanceled(true);
                return;
            }
            if (!noInteraction && offhand.method_7960()) {
                return;
            }
        }
        if (offhand.method_7960()) {
            if (!player.method_5767() && mainhand.method_7909() != class_1802.field_8204 && ModifierUtil.getTotalModifierLevel((class_1309)player, TinkerDataKeys.SHOW_EMPTY_OFFHAND) > 0) {
                class_4587 matrices = event.getPoseStack();
                matrices.method_22903();
                class_310.method_1551().method_1561().method_43336().method_3219(matrices, event.getMultiBufferSource(), event.getPackedLight(), event.getEquipProgress(), event.getSwingProgress(), player.method_6068().method_5928());
                matrices.method_22909();
                event.setCanceled(true);
            }
        } else if (offhand.method_31573(TinkerTags.Items.TWO_HANDED) && !ModifierUtil.checkVolatileFlag(offhand, IModifiable.DEFER_OFFHAND)) {
            event.setCanceled(true);
        }
    }

    static float handleZoom(class_742 player, float fov) {
        AtomicReference<Float> newFovRef = new AtomicReference<Float>(Float.valueOf(fov));
        TinkerDataCapability.CAPABILITY.maybeGet((Object)player).ifPresent(data -> {
            FloatMultiplier constZoom;
            FloatMultiplier scaledZoom;
            float newFov = fov;
            float effectScale = ((Double)class_310.method_1551().field_1690.method_42454().method_41753()).floatValue();
            if (effectScale > 0.0f && (scaledZoom = data.get(TinkerDataKeys.SCALED_FOV_MODIFIER)) != null) {
                if (effectScale == 1.0f) {
                    newFov *= scaledZoom.getValue();
                } else {
                    float original = fov;
                    newFov *= class_3532.method_16439((float)effectScale, (float)1.0f, (float)(scaledZoom.getValue() * original)) / original;
                }
            }
            if ((constZoom = data.get(TinkerDataKeys.FOV_MODIFIER)) != null) {
                newFov *= constZoom.getValue();
            }
            newFovRef.set(Float.valueOf(newFov));
        });
        return newFovRef.get().floatValue();
    }

    static void equipmentChange(ToolEquipmentChangeEvent event) {
        InventoryModifier modifier;
        IToolStackView tool;
        EquipmentChangeContext context = event.getContext();
        if (((Boolean)Config.CLIENT.renderShieldSlotItem.get()).booleanValue() && event.getEntity() == class_310.method_1551().field_1724 && context.getChangedSlot() == class_1304.field_6172) {
            tool = context.getToolInSlot(class_1304.field_6172);
            if (tool != null) {
                modifier = (ShieldStrapModifier)TinkerModifiers.shieldStrap.get();
                ModifierEntry entry = tool.getModifiers().getEntry(modifier.getId());
                if (entry != null) {
                    nextOffhand = modifier.getStack(tool, entry, 0);
                    return;
                }
            }
            nextOffhand = class_1799.field_8037;
        }
        if (((Boolean)Config.CLIENT.renderItemFrame.get()).booleanValue() && event.getEntity() == class_310.method_1551().field_1724 && context.getChangedSlot() == class_1304.field_6169) {
            int level;
            itemFrames.clear();
            tool = context.getToolInSlot(class_1304.field_6169);
            if (tool != null && (level = tool.getModifierLevel(modifier = (ItemFrameModifier)TinkerModifiers.itemFrame.get())) > 0) {
                ((ItemFrameModifier)modifier).getAllStacks(tool, level, itemFrames);
            }
        }
    }
}

